﻿<%@ Page Title="" Language="C#" MasterPageFile="~/Project.master" AutoEventWireup="true"
    CodeBehind="ProjectUser.aspx.cs" Inherits="GUI.Pages.ProjectUser" %>

<%@ Register TagPrefix="uc" Namespace="GUI.Controls" Assembly="GUI" %>
<%@ Register Src="~/Controls/ProjectNavTest.ascx" TagName="ProjectNavTest" TagPrefix="uc" %>
<asp:Content ID="Content3" ContentPlaceHolderID="LeftNavigationPlaceHolder" runat="server">
    <uc:ProjectNavTest ID="ProjectNavTest" runat="server" />
</asp:Content>
<asp:Content ID="Content4" ContentPlaceHolderID="FormPlaceHolder" runat="server">
<div class="row">
    <div class="col-md-12 col-sm-12">
    <div class="portlet light bordered light-blue">
            <div class="portlet-title">
                <div class="caption">
                    <span class="caption-subject bold font-dark uppercase"> <asp:Literal ID="Literal1" runat="server" Text="<%$ Resources:ProjectManagementUI, UI_ProjectUsers %>" /> </span>
                </div>
            </div>
            <div class="portlet-body form">
                <div class="form-body">
                      <div class="row">
                            <div class="col-md-3">
                                <div class="form-group">
                                    <label class="control-label"><asp:Literal ID="Literal38" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_User %>" /></label>
                                    <div class="input-group">
                                        <asp:DropDownList runat="server" ValidationGroup="Validacija" CssClass="form-control" ID="ddlUser" />
                                        <span class="input-group-btn">
                                            <asp:LinkButton ID="btnAddUser" OnClick="BtnAddClick" CssClass="btn blue" runat="server">
                                                <i class="fa fa-plus"></i>
                                            </asp:LinkButton>	
                                        </span>
                                    </div> 
                                    <span class="help-block"> <asp:RequiredFieldValidator ID="ddlUserRequired" ValidationGroup="Validacija" runat="server" Display="Dynamic"
                                    CssClass="vError" SetFocusOnError="true" ControlToValidate="ddlUser" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                                    ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal4" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span>
                                </div>
                            </div>
                            <div class="col-md-3">
                                <div class="form-group">
                                    <asp:Literal ID="Literal39" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_Description %>" /></label>
                                    <div class="form-group" style="margin-top:5px; !important">
                                        <asp:TextBox runat="server" ValidationGroup="Validacija"  CssClass="form-control" ID="txtDescription" />
                                    </div> 
                                    <span class="help-block"><asp:RequiredFieldValidator ID="RequiredFieldValidator1" ValidationGroup="Validacija" runat="server" Display="Dynamic"
                                    CssClass="vError" SetFocusOnError="true" ControlToValidate="ddlUser" ErrorMessage="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>"
                                    ToolTip="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>">* <asp:Literal ID="Literal2" runat="server" Text="<%$ Resources:ProjectManagementUI, Common_MandatoryField %>" /></asp:RequiredFieldValidator></span>
                                </div>
                            </div>
                            <div class="form-actions left" style="border-top: none; margin-top: 4px;">
                                        <asp:Button ID="btnSave" ValidationGroup="Validacija" OnClick="BtnSaveClick" CssClass="btn red" Text="<%$ Resources:ProjectManagementUI, Common_Save %>"
                                    runat="server" />
                                </div>
                        </div>

                        <telerik:RadGrid ID="grdProjectUsers" runat="server" OnItemCommand="grdProjectUsers_OnItemCommand" CssClass="kendo-table" Skin="Bootstrap">
                            <MasterTableView ShowHeadersWhenNoRecords="true" NoMasterRecordsText="<%$ Resources:ProjectManagementUI, Common_NoData %>" CssClass="table table-striped table-hover"
                                ShowFooter="False" AutoGenerateColumns="False" AllowCustomSorting="false" DataKeyNames="Id">
                                <Columns>
                                    <telerik:GridBoundColumn UniqueName="IdColumn" HeaderText="Id" DataField="Id" />
                                    <telerik:GridBoundColumn UniqueName="CodeColumn" SortExpression="Code" HeaderText="<%$ Resources:ProjectManagementUI, Common_Code %>"
                                        DataField="ProjectUser.Code" />
                                    <telerik:GridBoundColumn UniqueName="NameColumn" SortExpression="Name" HeaderText="<%$ Resources:ProjectManagementUI, Common_Name %>"
                                        DataField="ProjectUser.NameLocalized" />
                                        <telerik:GridBoundColumn UniqueName="DescriptionColumn" SortExpression="Description" HeaderText="<%$ Resources:ProjectManagementUI, Common_Description %>"
                                        DataField="Description" />
                                    <telerik:GridButtonColumn CommandName="Delete" UniqueName="DeleteColumn" HeaderStyle-Width="5%"
                                        ButtonCssClass="btn btn-sm blue" HeaderText="" ButtonType="LinkButton" Text="<%$ Resources:ProjectManagementUI, Common_Delete %>" ConfirmText="<%$ Resources:ProjectManagementUI, Common_DeletingConfirm %>"
                                        ConfirmTitle="<%$ Resources:ProjectManagementUI, Common_Deleting %>" />
                                </Columns>
                            </MasterTableView>
                        </telerik:RadGrid>          

                </div>
            </div>
        </div>
    </div>
</div>
</asp:Content>
